within ModelicaLib.IFV_Lib.Diesel_Engine_test;
model EngineSimple
        parameter Real max_torque_val(start = 100.0);
        Modelica.Mechanics.Rotational.Sources.Torque torque annotation(Placement(transformation(extent = {{16,22},{36,42}})));
        Modelica.Mechanics.Rotational.Components.Inertia inertia(J = 0.01) annotation(Placement(transformation(extent = {{54,22},{74,42}})));
        Modelica.Mechanics.Rotational.Interfaces.Flange_b flange annotation(Placement(transformation(extent = {{84,22},{104,42}}), iconTransformation(extent = {{90,-10},{110,10}})));
        Modelica.Blocks.Interfaces.RealInput Throttle annotation(Placement(transformation(extent = {{-112,-38},{-72,2}}), iconTransformation(extent = {{-120,-20},{-80,20}})));
        Modelica.Blocks.Math.Product product1 annotation(Placement(transformation(extent = {{-32,-22},{-12,-2}})));
        Modelica.Blocks.Sources.Constant const(k = max_torque_val) annotation(Placement(transformation(extent = {{-92,10},{-72,30}})));
        Modelica.Blocks.Interfaces.RealOutput fuelFlow annotation(Placement(transformation(extent = {{80,-58},{100,-38}})));
        Modelica.Blocks.Sources.Constant const1(k = 1) annotation(Placement(transformation(extent = {{50,-58},{70,-38}})));
      equation
        connect(torque.flange,inertia.flange_a) annotation(Line(points = {{36,32},{54,32}}, color = {0,0,0}, smooth = Smooth.None));
        connect(const.y,product1.u1) annotation(Line(points = {{-71,20},{-60,20},{-60,-2},{-34,-2},{-34,-6}}, color = {0,0,127}, smooth = Smooth.None));
        connect(Throttle,product1.u2) annotation(Line(points = {{-92,-18},{-34,-18}}, color = {0,0,127}, smooth = Smooth.None));
        connect(product1.y,torque.tau) annotation(Line(points = {{-11,-12},{-2,-12},{-2,32},{14,32}}, color = {0,0,127}, smooth = Smooth.None));
        connect(inertia.flange_b,flange) annotation(Line(points = {{74,32},{94,32}}, color = {0,0,0}, smooth = Smooth.None));
        connect(const1.y,fuelFlow) annotation(Line(points = {{71,-48},{90,-48}}, color = {0,0,127}, smooth = Smooth.None));
        annotation(uses(Modelica(version = "3.2")), Diagram(graphics), Icon(graphics = {Text(extent = {{-68,88},{84,-64}}, lineColor = {0,0,255}, textString = "EngineSimple")}));
end EngineSimple;
